/******************************************************************************
 * Technical University of Technology Darmstadt
 * Industrial Process and System Communication
 * Project:  TCP
 * Filename: MainWindow.java
  * Contents: Places the panels in a Frame with GridBagLayout
  *****************************************************************************/

import java.awt.GridBagLayout;
import java.awt.GridBagConstraints;
import java.awt.Label;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Event;
import java.awt.Scrollbar;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Button;
import java.awt.LayoutManager;
import java.awt.Color;
import java.util.Date;

/******************************************************************************
* Class: MainWindow
* Description: organizes everything concerning the GUI.
******************************************************************************/
public class MainWindow extends Frame  {
  TcpStarter parent;
  MenuBar menub;
  Menu userlevelMenu, optionsMenu, screenMenu, modusMenu, graphicsMenu;
  MenuItem menuibeginner,menuiadvanced, menuiquit, menuclserv, menuauto;
  MenuItem menuichpict, menuiarrow;
  MenuItem menuisize1, menuisize2, menuisize3, menuisize4;
  Dimension framedimension;
  Point frameposition;
  GridBagLayout gbl1 = new GridBagLayout();
  GridBagLayout gbl2 = new GridBagLayout();
  GridBagLayout gbl3 = new GridBagLayout();
  GridBagLayout gbl4 = new GridBagLayout();
  GridBagConstraints gbc = new GridBagConstraints();
  Font font1, font2, font3, font4, font;
  ImagePanel layer5panel1 , layer4panel1, netpanel;
  ImagePanel layer5panel2 , layer4panel2;
  LinePanel  linepanel11, linepanel12, linepanel21, linepanel22;
  Host host1panel,host2panel;
  Channel ch_window = new Channel();     // Netz erzeugen
  HeaderHistory historypanel;
  Label info_label,h1stat_label,h2stat_label;
  Button host1_but, host2_but, fsm_but;
  Button abort1_but, abort2_but, reset_but;
  boolean adv_bool= false;
  boolean auto_bool = true;
  boolean fsm_bool = false;
  int counter, conid1, conid2, suc1, suc2, abort1, abort2;
  short locport = 23;
  short destport = 23;
  String type;
  int to_place;
  String hostpict = "clientpict";
  FSMWindow fsm_window;


  public MainWindow(TcpStarter target) {
    this.parent = target;
    menub         = new MenuBar();
    userlevelMenu = new Menu( "Userlevel");
    graphicsMenu  = new Menu( "Graphics");
    optionsMenu   = new Menu( "Options" );
    screenMenu    = new Menu( "Screen" );
    modusMenu     = new Menu( "Modus" );
    menuibeginner = new MenuItem( "Beginner" );
    menuiadvanced = new MenuItem( "Advanced");
    menuichpict   = new MenuItem( "Channel-Pictures");
    menuiarrow    = new MenuItem( "Arrows");
    menuiquit     = new MenuItem( "Quit" );
    menuisize1    = new MenuItem( "640 x 480" );
    menuisize2    = new MenuItem( "800 x 600" );
    menuisize3    = new MenuItem( "1024 x 768" );
    menuisize4    = new MenuItem( "1280 x 1024" );
    menuclserv    = new MenuItem( "Client <--> Server" );
    menuauto      = new MenuItem( "Automatic Open and Close"  );
    userlevelMenu. add( menuibeginner);
    userlevelMenu. add( menuiadvanced);
    optionsMenu.   add( userlevelMenu );
    optionsMenu.   addSeparator();
    graphicsMenu.  add( menuichpict);
    graphicsMenu.  add( menuiarrow);
    optionsMenu.   add( graphicsMenu );
    optionsMenu.   addSeparator();
    optionsMenu.   add( menuiquit );
    screenMenu.    add( menuisize1 );
    screenMenu.    add( menuisize2 );
    screenMenu.    add( menuisize3 );
    screenMenu.    add( menuisize4 );
    //modusMenu.     add( menuclserv );
    modusMenu.     add( menuauto );
    menub. add( optionsMenu );
    menub. add( screenMenu );
    menub. add( modusMenu );
    setMenuBar( menub );
    font1 = new Font( "font1", Font.ITALIC, 11 );
    font2 = new Font( "font2", Font.ITALIC, 14 );
    font3 = new Font( "font3", Font.ITALIC, 18 );
    font4 = new Font( "font4", Font.ITALIC, 22 );
    layer5panel1 = new ImagePanel( parent , "telnetpict" );
    layer5panel2 = new ImagePanel( parent , "telnetpict" );
    layer4panel1 = new ImagePanel( parent , "clientpict" );
    layer4panel2 = new ImagePanel( parent , "clientpict" );
    netpanel     = new ImagePanel( parent , "netpict"    );
    linepanel11  = new LinePanel ( parent , "layer4_5-1" );
    linepanel21  = new LinePanel ( parent , "layer3_4-1" );
    historypanel = new HeaderHistory(parent.host1, parent.host2, parent, parent.screenfactor);
    info_label   = new Label ( "Please choose userlevel in menu 'Options'",Label.CENTER );
    host1_but    = new Button( "Start" );
    host2_but    = new Button( "pas.Open" );
    abort1_but   = new Button( "Abort");
    abort2_but   = new Button( "Abort");
    reset_but    = new Button( "Reset");
    reset_but. disable();
    fsm_but    = new Button( "TCP - Finite State Machine");
    h1stat_label  = new Label ( "Status",Label.CENTER );
    h2stat_label  = new Label ( "Status",Label.CENTER );
    host1panel = parent.host1;
    host2panel = parent.host2;
    ch_window. Channel( parent, "Channel") ;


    // GridBagLayout declarations for 640x480 Pixels
    int rowHeights1[] = {25,20,70,5,30,70,40,40,20,50,5,20,40,5 };
    int columnWidths1[] = { 5,90,90,45,180,45,90,90,5 };
    double rowWeights1[] = { 0,0,0,0,0,0,0,0,0,0,0,0 };
    double columnWeights1[] = { 0,0,0,0,0,0,0,0,0 };
    gbl1.rowHeights = rowHeights1;
    gbl1.columnWidths = columnWidths1;
    gbl1.rowWeights = rowWeights1;
    gbl1.columnWeights = columnWeights1;

    // GridBagLayout declarations for 800x600 Pixels
    int rowHeights2[] = { 31,23,88,6,40,88,50,50,25,63,6,25,50,6 };
    int columnWidths2[] = { 6,112,112,57,225,57,113,112,6 };
    double rowWeights2[] = { 0,0,0,0,0,0,0,0,0,0,0,0 };
    double columnWeights2[] = { 0,0,0,0,0,0,0,0,0 };
    gbl2.rowHeights = rowHeights2;
    gbl2.columnWidths = columnWidths2;
    gbl2.rowWeights = rowWeights2;
    gbl2.columnWeights = columnWeights2;

    // GridBagLayout declarations for 1024x768 Pixels
    int rowHeights3[] = { 40,26,112,8,54,112,64,64,32,82,8,32,64,8 };
    int columnWidths3[] = { 8,144,144,72,288,72,144,144,8 };
    double rowWeights3[] ={ 0,0,0,0,0,0,0,0,0,0,0,0 };
    double columnWeights3[] = { 0,0,0,0,0,0,0,0,0 };
    gbl3.rowHeights = rowHeights3;
    gbl3.columnWidths = columnWidths3;
    gbl3.rowWeights = rowWeights3;
    gbl3.columnWeights = columnWeights3;

    // GridBagLayout declarations for 1280x1024 Pixels
    int rowHeights4[] = { 50,30,140,10,70,140,80,80,40,100,10,40,80,10 };
    int columnWidths4[] = { 10,180,180,90,360,90,180,180,10 };
    double rowWeights4[] ={ 0,0,0,0,0,0,0,0,0,0,0,0 };
    double columnWeights4[] = { 0,0,0,0,0,0,0,0,0 };
    gbl4.rowHeights = rowHeights4;
    gbl4.columnWidths = columnWidths4;
    gbl4.rowWeights = rowWeights4;
    gbl4.columnWeights = columnWeights4;

    //GridBagConstraints declaration for all Screensizes
    resetConstraints();
    gbc.fill = GridBagConstraints.BOTH;
    gbc.weightx = 0.0;
    gbc.weighty = 0.0;
    gbc.anchor = GridBagConstraints.CENTER;
    gbc.insets = new Insets( 2, 2, 2, 2 );
    insertComponent( layer5panel1, 1, 2 );
    insertComponent( layer5panel2, 7, 2 );
    insertComponent( layer4panel1, 1, 4 );
    insertComponent( layer4panel2, 7, 4 );
    insertComponent( h1stat_label, 1, 7 );
    insertComponent( h2stat_label, 7, 7 );
    insertComponent( fsm_but     , 4, 1 );
    insertComponent( reset_but   , 4, 11);
    gbc.gridwidth  = 9;
    gbc.gridheight = 1;
    insertComponent( linepanel11 , 0, 3 );
    insertComponent( linepanel21 , 0, 10 );
    gbc.gridwidth  = 5;
    gbc.gridheight = 7;
    insertComponent( historypanel,2, 3 );
    historypanel.requestFocus();
    gbc.gridwidth  = 3;
    gbc.gridheight = 1;
    gbc.insets = new Insets( 2, 2, 2, 2 );
    insertComponent( info_label, 3, 2 );

    //set Startup-Frame
    setLayout( gbl1 );
    setTitle( "Transmission Control Protocol" );
    setBackground(Color.lightGray);
    changeScreenMan( 1 );
    validate();
    show();
  }

/******************************************************************************
* Method: setPict
* Description: changes the Picture of Layer 4
*
* Parameters: String picture, int
* Return Value: none
******************************************************************************/
  public void setPict(String type,int to_place) {
    switch(to_place) {
      case 1:
    	if (type.equals("SERVER")) {
    	  layer4panel1.changeSize(parent.screenfactor, "serverpict");
    	}
    	if (type.equals("CLIENT")) {
    	  layer4panel1.changeSize(parent.screenfactor, "clientpict");
    	}
    	validate();
    	break;
      case 2:
    	if (type.equals("SERVER")) {
    	  layer4panel2.changeSize(parent.screenfactor, "serverpict");
    	}
    	if (type.equals("CLIENT")) {
    	  layer4panel2.changeSize(parent.screenfactor, "clientpict");
    	}
    	validate();
    	break;
    }
  }


/******************************************************************************
* Method: insertComponent
* Description: adds components on defined places using GridBagLayout.
* Parameters: comp is the current component, x,y define the position.
* Return Value: none
******************************************************************************/
  public void insertComponent( Component comp, int x, int y ){
    gbc.gridx = x;
    gbc.gridy = y;
    gbl1. setConstraints( comp, gbc );
    gbl2. setConstraints( comp, gbc );
    gbl3. setConstraints( comp, gbc );
    gbl4. setConstraints( comp, gbc );
    add( comp );
  }

/******************************************************************************
* Method: resetConstraints
* Description: resets all Constraints definitions.
* Parameters: none
* Return Value: none
******************************************************************************/
  public void resetConstraints(){
    gbc.gridx = 0;
    gbc.gridy = 0;
    gbc.gridwidth = 1;
    gbc.gridheight = 1;
    gbc.fill = gbc.BOTH;
    gbc.anchor = gbc.CENTER;
    gbc.insets = new Insets( 0, 0, 0, 0 );
    gbc.ipadx = 0;
    gbc.ipady = 0;
    gbc.weightx = 1.0;
    gbc.weighty = 1.0;
  }

/******************************************************************************
* Method: changeScreenAuto
* Description: changes the Screensize automatically to fixed sizes. There are
*   four given sizes.
* Parameters: none
* Return Value: none
******************************************************************************/
  public void changeScreenAuto(){
    int x, y, dx, dy;
    frameposition = this.location();
    framedimension = this.size();
    x = frameposition.x;
    y = frameposition.y;
    dx = framedimension.width;
    dy = framedimension.height;
    if ( ( dx < 720 ) || ( dy < 540 ) ){
      parent.screenfactor = 1;
      resize( 650, 540 );
      setLayout( gbl1 );
      validate();
    }
    else if ( ( dx < 912 ) || ( dy < 684 ) ){
      parent.screenfactor = 2;
      resize( 810, 650 );
      setLayout( gbl2 );
      validate();
    }
    else if ( ( dx < 1152 ) || ( dy < 896 ) ){
      parent.screenfactor = 3;
      resize( 1034, 800 );
      setLayout( gbl3 );
      validate();
    }
    else {
      parent.screenfactor = 4;
      resize( 1290, 1080 );
      setLayout( gbl4 );
      validate();
    }
    editFonts();
    scaleComponents();
    this.move( x, y );
  }




/******************************************************************************
* Method: changeScreenMan
* Description: changes the screensize to the chosen menu value.
* Parameters: factor is the screensize-ID
* Return Value: none
******************************************************************************/
  public void changeScreenMan( int factor ){
    int x, y;
    frameposition = this.location();
    x = frameposition.x;
    y = frameposition.y;
    if ( factor == 1 ){
      parent.screenfactor = 1;
      resize( 650, 540 );
      setLayout( gbl1 );
      validate();
    }
    else if ( factor == 2 ){
      parent.screenfactor = 2;
      resize( 810, 650 );
      setLayout( gbl2 );
      validate();
    }
    else if ( factor == 3 ){
      parent.screenfactor = 3;
      resize( 1034, 800 );
      setLayout( gbl3 );
      validate();
    }
    else if ( factor == 4 ){
      parent.screenfactor = 4;
      resize( 1290, 1080 );
      setLayout( gbl4 );
      validate();
    }
    editFonts();
    scaleComponents();
    this.move( x, y );
  }

/******************************************************************************
* Method: editFonts
* Description: scales all other components using the screensizefactor when
*   the screensize was changed.
* Parameters: none
* Return Value: none
******************************************************************************/
  public void editFonts(){

    switch(parent.screenfactor) {
    case 1:
      font = font1;
      break;
    case 2:
      font = font2;
      break;
    case 3:
      font = font3;
      break;
    case 4:
      font = font4;
      break;
    }
    h1stat_label .setFont(font);
    h2stat_label .setFont(font);
    host1_but .setFont(font);
    host2_but .setFont(font);
    info_label  .setFont(font);
    fsm_but .setFont(font);

  }
/******************************************************************************
* Method: scaleComponents
* Description: scales all other components using the screensizefactor when
*   the screensize was changed.
* Parameters: none
* Return Value: none
******************************************************************************/
  public void scaleComponents(){
    layer5panel1. changeSize( parent.screenfactor, "" );
    layer5panel2. changeSize( parent.screenfactor, "" );
    layer4panel1. changeSize( parent.screenfactor, "" );
    layer4panel2. changeSize( parent.screenfactor, "" );
    netpanel.     changeSize( parent.screenfactor, "netpict" );
    linepanel11.  changeSize( parent.screenfactor, "" );
    linepanel21.  changeSize( parent.screenfactor, "" );
    historypanel. changeSize( parent.screenfactor, "" );
    validate();
  }

/******************************************************************************
* Method: setBeginner
* Description:
* Parameters: none
* Return Value: none
******************************************************************************/
  public void setBeginner(){
    if((parent.chkstat.getState(parent.host1).equals("CLOSED"))&(parent.chkstat.getState(parent.host1).equals("CLOSED"))){
      adv_bool = false;
      this .remove(host1panel);
      this .remove(host2panel);
      auto_bool = true;
      layer5panel1. changeSize(parent.screenfactor,"telnetpict");
      layer5panel2. changeSize(parent.screenfactor,"telnetpict");
      historypanel.hist.advanced = false;
      info_label. setText("Please choose simulationmodus in menu 'Modus'");
    }
    else {
      info_label. setText("Please Close Connection first!");
    }
  }
/******************************************************************************
* Method: setAdvanced
* Description:
* Parameters: none
* Return Value: none
******************************************************************************/
  public void setAdvanced(){
    if((parent.chkstat.getState(parent.host1).equals("CLOSED"))&(parent.chkstat.getState(parent.host1).equals("CLOSED"))){
      adv_bool = true;
      reset_but .enable();
      layer5panel1. changeSize(parent.screenfactor,"telnet1pict");
      layer5panel2. changeSize(parent.screenfactor,"telnet1pict");
      this .remove(host1_but);
      this .remove(host2_but);
      this .remove(abort1_but);
      this .remove(abort2_but);
      resetConstraints();
      gbc.fill = GridBagConstraints.BOTH;
      gbc.weightx = 0.0;
      gbc.weighty = 0.0;
      gbc.anchor = GridBagConstraints.CENTER;
      gbc.insets = new Insets( 2, 2, 2, 2 );
      gbc.gridwidth  = 1;
      gbc.gridheight = 2;
      insertComponent( host1panel  , 1, 5 );
      insertComponent( host2panel  , 7, 5 );
      validate();
      historypanel.hist.advanced = true;
      info_label. setText("TCP for Advanced");
    }
    else {
      info_label. setText("Please Close Connection first!");
    }
  }
/******************************************************************************
* Method:  clickedhost1_but
* Description:
* Parameters: none
* Return Value: none
******************************************************************************/
  public void clickedhost1_but(){
      if(auto_bool) automaticModus();
      else {
        if(host1_but.getLabel() == "act.Open" ) {
          host1_but. disable();
          host2_but. disable();
          if (adv_bool) {
            info_label. setText("Simulation started in Userlevel: Advanced");
            }
          else {
            reset_but .enable();
            conid1 = parent.host1.t1.Open(locport,destport,1);
            if (conid1 >= 0) {
              info_label. setText("active OPEN");
              host1_but. setLabel( "Close" );
    	      resetConstraints();
    	      gbc.fill = GridBagConstraints.BOTH;
    	      gbc.weightx = 0.0;
    	      gbc.weighty = 0.0;
    	      gbc.anchor = GridBagConstraints.CENTER;
    	      gbc.insets = new Insets( 5, 5, 5, 5 );
    	      insertComponent(abort1_but,1,1);
    	      validate();
            }
            else {
              host1_but. enable();
              host2_but. enable();
            }
          }
        }
        else if (host1_but.getLabel() == "Close" ) {
          host1_but. disable();
          host2_but. disable();
          suc1 = parent.host1.t1.Close(conid1);
	      info_label. setText("Close");
          if (suc1 == 0) {
            host2_but. enable();
          }
          else {
            host1_but. enable();
            host2_but. enable();
          }
        }
      }
  }
/******************************************************************************
* Method:  clickedhost2_but
* Description:
* Parameters: none
* Return Value: none
******************************************************************************/
  public void clickedhost2_but(){
    System.out.println("Hier in clickedhost2_but() 0");
    if(host2_but.getLabel() == "pas.Open" ) {
      System.out.println("Hier in clickedhost2_but() 1");
      host1_but. disable();
      host2_but. disable();
      if (adv_bool) {
        info_label. setText("Simulation started in Userlevel: Advanced");
      }
      else {
        System.out.println("Hier in clickedhost2_but()-2");
        reset_but .enable();
        conid2=parent.host2.t1.Open(locport,destport,0);
        if (conid2 >= 0) {
          info_label. setText("passive OPEN");
          host2_but. setLabel( "Close" );
	      resetConstraints();
          gbc.fill = GridBagConstraints.BOTH;
          gbc.weightx = 0.0;
          gbc.weighty = 0.0;
          gbc.anchor = GridBagConstraints.CENTER;
          gbc.insets = new Insets( 5, 5, 5, 5 );
          insertComponent(abort2_but,7,1);
          validate();
          host1_but. enable();
        }
        else {
          host1_but. enable();
          host2_but. enable();
        }
      }
    }
    else {
      if (host2_but.getLabel() == "Close" ) {
          host1_but. disable();
          host2_but. disable();
          suc2 = parent.host2.t1.Close(conid2);
          info_label. setText("Close");
          if (suc2 == 0) {
            host1_but. enable();
          }
          else {
            host1_but. enable();
            host2_but. enable();
          }
      }
    }
  }
/******************************************************************************
* Method:  clickedabort1_but
* Description:
* Parameters: none
* Return Value: none
******************************************************************************/
  public void clickedabort1_but() {
    abort1 = parent. host1.t1.Abort(conid2);
    abort2 = parent. host2.t1.Abort(conid1);
    if (abort1>=0) {
      setPict("CLIENT",1);
      this .remove(abort1_but);
      host1_but. setLabel("act.Open");
    }
    if (abort1>=0) {
      setPict("CLIENT",2);
      this .remove(abort2_but);
      host2_but. setLabel("pas.Open");
    }
    if ((abort1>=0)&(abort2>=0)) {
      host1_but. enable();
      host2_but. enable();
    }
  }
/******************************************************************************
* Method:  clickedreset_but
* Description:
* Parameters: none
* Return Value: none
******************************************************************************/
  public void clickedreset_but(){
    historypanel.clickedClearButton();
    if (parent.host1in.size()>0) parent.host1in.removeAllElements();
    if (parent.host1out.size()>0) parent.host1out.removeAllElements();
    if (parent.host2in.size()>0) parent.host2in.removeAllElements();
    if (parent.host2out.size()>0) parent.host2out.removeAllElements();
    int id1 = parent.host1.getID();
    int id2 = parent.host2.getID();
    //parent.host1.t1.Abort(id1);
    //parent.host2.t1.Abort(id2);
    int y1, y2;
    if((y1 = new Suche().conid(id1,parent.host1.t1.tcbbuffer))>=0) {
      parent.host1.t1.tcbbuffer.removeElementAt(y1); //remove TCB
      parent.host1.t1.cid--;
    }
    if(( y2 = new Suche().conid(id2,parent.host2.t1.tcbbuffer))>=0) {
      parent.host2.t1.tcbbuffer.removeElementAt(y2); //remove TCB
      parent.host2.t1.cid--;
    }
    //if (parent.host1.t1.seg_arrive.tcb.size()>0) parent.host1.t1.tcbbuffer.removeAllElements();
    //if (parent.host2.t1.seg_arrive.tcb.size()>0) parent.host2.t1.tcbbuffer.removeAllElements();
    setPict("CLIENT",1);
    setPict("CLIENT",2);
    if (fsm_bool == true) fsm_window.closeWindow();
    if (adv_bool){
      for (int counter = 0; counter<parent.maxapp;counter++){
        if(parent.appsonh1[counter].isShowing()) {
          parent.appsonh1[counter].clickeddismissbutton();
        }
        if(parent.appsonh2[counter].isShowing()) {
          parent.appsonh2[counter].clickeddismissbutton();
        }
      }
    }
    else {
      if(auto_bool){
        host1_but. setLabel("Start");
        host1_but. enable();
        info_label. setText("You can open a connection with 'Start'");
      }
      else {
        this .remove(abort1_but);
        this .remove(abort2_but);
        host1_but. setLabel("act.Open");
        host1_but. enable();
        host2_but. setLabel("pas.Open");
        host2_but. enable();
        info_label .setText("Now you can start simulation!");
      }
    }
    validate();
  }
/******************************************************************************
* Method:  automaticModus
* Description: processes for automatic mode
* Parameters: none
* Return Value: none
******************************************************************************/
  public void automaticModus(){
    if(host1_but.getLabel() == "Start" ) {
      host1_but. setLabel( "Close" );
      host1_but. disable();
      if (adv_bool) {
        info_label. setText("Simulation started in Userlevel: Advanced");
        }
      else {
        reset_but .enable();
        conid2=parent.host2.t1.Open(locport,destport,0);
        if (conid2 >= 0) {
            conid1=parent.host1.t1.Open(locport,destport,1);
            if (conid1 >= 0) {
              info_label. setText("You can close the connection with 'Close'");
              host1_but. enable();
            }
            else clickedabort1_but();
        }
        else clickedabort1_but();
      }
    }
    else
      if (host1_but.getLabel() == "Close" ) {
      host1_but. setLabel( "Start" );
      host1_but. disable();
      suc1 = parent.host1.t1.Close(conid1);
      if (suc1 == 0) {
        suc2 = parent.host2.t1.Close(conid2);
        if (suc2 == 0){
	        info_label. setText("Simulation stopped");
            reset_but .disable();
	    }
      }
    }
  }
/******************************************************************************
* Method:  clickedfsm_but
* Description:
* Parameters: none
* Return Value: none
******************************************************************************/
  public void clickedfsm_but(){
    fsm_window = new FSMWindow(parent, parent.host1, parent.host2);
    boolean fsm_bool = true;
  }
/******************************************************************************
* Method:  setClientServ
* Description:
* Parameters: none
* Return Value: none
******************************************************************************/
  public void setClientServ(){
    info_label .setText("Now you can start simulation!");
    auto_bool = false;
    fsm_but. enable();
    resetConstraints();
    gbc.fill = GridBagConstraints.BOTH;
    gbc.weightx = 0.0;
    gbc.weighty = 0.0;
    gbc.anchor = GridBagConstraints.CENTER;
    gbc.insets = new Insets( 2, 2, 2, 2 );
    insertComponent( host1_but,  2, 1 );
    insertComponent( host2_but,  6, 1 );
    host1_but.setLabel("act.Open");
    host2_but.enable();
    validate();
  }
/******************************************************************************
* Method:  setAutomaticMode
* Description:
* Parameters: none
* Return Value: none
******************************************************************************/
  public void setAutomaticMode(){
    info_label. setText("You can open a connection with 'Start'");
    auto_bool = true;
    this .remove(host2_but);
    resetConstraints();
    gbc.fill = GridBagConstraints.BOTH;
    gbc.weightx = 0.0;
    gbc.weighty = 0.0;
    gbc.anchor = GridBagConstraints.CENTER;
    gbc.insets = new Insets( 2, 2, 2, 2 );
    insertComponent( host1_but,  2, 1 );
    validate();
    fsm_but. enable();
    host1_but. setLabel("Start");
    host1_but. enable();
  }
/******************************************************************************
* Method: update
* Description:
* Parameters: the used graphic
* Return Value: none
******************************************************************************/
  public void update( Graphics g ){
    paint( g );
  }

/******************************************************************************
* Method: handleEvent
* Description: handles all Events for the menubar, slider, checkboxes, and
*   various mouseevents.
* Parameters: comp is the current component, x,y define the position.
* Return Value: none
******************************************************************************/
   public boolean handleEvent(Event event) {
    if ( event.id == Event.ACTION_EVENT && event.target == menuiquit ) {
      dispose();
      System.exit( 0 );
      return true;
    }
    else if ( event.id == Event.ACTION_EVENT && event.target == menuisize1 ) {
      changeScreenMan( 1 );
      return true;
    }
    else if ( event.id == Event.ACTION_EVENT && event.target == menuisize2 ) {
      changeScreenMan( 2 );
      return true;
    }
    else if ( event.id == Event.ACTION_EVENT && event.target == menuisize3 ) {
      changeScreenMan( 3 );
      return true;
    }
    else if ( event.id == Event.ACTION_EVENT && event.target == menuisize4 ) {
      changeScreenMan( 4 );
      return true;
    }
    else if ( event.id == Event.ACTION_EVENT && event.target == menuibeginner ) {
      setBeginner();
      return true;
    }
    else if ( event.id == Event.ACTION_EVENT && event.target == menuiadvanced ) {
      setAdvanced();
      return true;
    }
    else if ( event.id == Event.ACTION_EVENT && event.target == menuichpict ) {
      historypanel.hist.setPictures(true);
      return true;
    }
    else if ( event.id == Event.ACTION_EVENT && event.target == menuiarrow ) {
      historypanel.hist.setPictures(false);
      return true;
    }
    else if ( event.id == Event.ACTION_EVENT && event.target == menuclserv ) {
      setClientServ();
      return true;
    }
    else if ( event.id == Event.ACTION_EVENT && event.target == menuauto ) {
      setAutomaticMode();
      return true;
    }
    else if ( event.id == Event.ACTION_EVENT && event.target == host1_but ) {
      clickedhost1_but();
      return true;
    }
    else if ( event.id == Event.ACTION_EVENT && event.target == host2_but ) {
      //System.out.println("event.target == host2_but");
      clickedhost2_but();
      return true;
    }
    else if ( event.id == Event.ACTION_EVENT && event.target == abort1_but ) {
      clickedabort1_but();
      return true;
    }
    else if ( event.id == Event.ACTION_EVENT && event.target == abort2_but ) {
      clickedabort1_but();
      return true;
    }
    else if ( event.id == Event.ACTION_EVENT && event.target == reset_but ) {
      clickedreset_but();
      return true;
    }
    else if ( event.id == Event.ACTION_EVENT && event.target == fsm_but ) {
      clickedfsm_but();
      return true;
    }
    else if (adv_bool) {
      if ( event.id == Event.MOUSE_DOWN && event.target == layer5panel1 ) {
        for (parent.counter=0;parent.counter<=(parent.maxapp-1);parent.counter++) {
            if (!parent.appsonh1[parent.counter].isShowing()){
                parent.appsonh1[parent.counter].enter();
                parent.counter=10;
            }
        }
	    return true;
      }
      else if ( event.id == Event.MOUSE_DOWN && event.target == layer5panel2 ) {
        for (parent.counter=0;parent.counter<=(parent.maxapp-1);parent.counter++) {
            if (!parent.appsonh2[parent.counter].isShowing()){
                parent.appsonh2[parent.counter].enter();
                parent.counter=10;
            }
        }
	    return true;
      }
      else if ( event.id == Event.MOUSE_DOWN && event.target == netpanel ) {
	    if (!ch_window.isShowing()) ch_window.enter();
          else ch_window.show();
	    return true;
      }
    }
    else if ( event.id == 1004 ) {
      changeScreenAuto();
      return true;
    }

    return super.handleEvent( event );
    }
/******************************************************************************
* Method: gotFocus
* Description: handles Event for serving the mouse into historypanel
* Parameters: comp is the current component, x,y define the position.
* Return Value: none
******************************************************************************/
   public boolean gotFocus(Event event,Object what) {
     if(event.target == historypanel){
       System .out.println("In History");
       historypanel. s1.enable();
     }
     return true;
   }
/******************************************************************************
* Method: lostFocus
* Description: handles Event for serving the mouse out of historypanel
* Parameters: comp is the current component, x,y define the position.
* Return Value: none
******************************************************************************/
   public boolean lostFocus(Event event,Object what) {
     if(event.target == historypanel){
       System .out.println("aus History");
       historypanel.s1.disable();
     }
     return true;
   }

}//END of class

